<?php
// FILE: protect_vulnerability_error_handling_custom.php
// protecting against common vulnerabilities

// using a custom error handler
function errorHandler($errno, $errstr, $errfile, $errline)
{
	$type  = 'Unknown';
	$fatal = FALSE;

	switch ($errno) {
		case E_USER_ERROR:
			$type = 'USER ERROR';
			$fatal = TRUE;
			break;

		case E_USER_WARNING:
			$type = 'USER WARNING';
			break;

		case E_USER_NOTICE:
			$type = 'USER NOTICE';
			break;

		case E_WARNING:
			$type = 'PHP WARNING';
			break;

		case E_NOTICE:
			$type = 'PHP NOTICE';
			break;

		case E_ERROR:
			$type = 'PHP FATAL';
			$fatal = TRUE;
			break;

		default:
			echo 'Unknown error type: ';
			break;
	}

	echo "<b>$type ERROR:</b> [$errno] $errstr<br />\n";
	echo "  On line $errline in file $errfile";
	echo ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\n";
	echo '<pre>';
	debug_print_backtrace();
	echo '</pre>';

	if ($fatal) {
		exit(1);
	}

	return true;
}
set_error_handler('errorHandler');

$name = $_GET['name'];
$value = array(1,2,3,4,5);
$list = '';

if ($value[5] == 0) {
	$error = 'No Value!';
}

foreach ($list as $item) {
	$check .= 'Item :' . $item;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Protect Against Vulnerabilities</title>
</head>
<body>
<h1>protect_vulnerability_error_handling_custom.php</h1>

<h3>TEST</h3>

<br />Name: <?php echo $name; ?>
<br />Check: <?php echo $check; ?>
<br />Value: <?php echo sum($value); ?>

</body>
</html>
